//
//
// sun.44.c
//
// solar tracker
//
// Babken Chugaszyan
// 19/06/2019
//
// (c)This work may be reproduced, modified, distributed, performed,
// and displayed for any purpose. No warranty is provided, and users accept all 
// liability.
//
#include <avr/io.h>
#include <util/delay.h>

#define output(directions,pin) (directions |= pin) // set port direction for output
#define set(port,pin) (port |= pin) // set port pin
#define clear(port,pin) (port &= (~pin)) // clear port pin
#define pin_test(pins,pin) (pins & pin) // test for port pin
#define bit_test(byte,bit) (byte & (1 << bit)) // test for bit set
#define PWM_delay() _delay_us(500) // PWM delay

#define led_port PORTB
#define led_direction DDRB
#define red (1 << PB1)
#define blue (1 << PB0)


  
  // 8-bit resolution
  // set ADLAR to 1 to enable the Left-shift result (only bits ADC9..ADC2 are available)
  // then, only reading ADCH is sufficient for 8-bit results (256 values)
void initADCul()
{
  ADMUX =
            (0 << ADLAR) |     // left shift result
            (0 << REFS1) |     // Sets ref. voltage to VCC, bit 1
            (0 << REFS0) |     // Sets ref. voltage to VCC, bit 0
            (0 << MUX3)  |     // use ADC0 for input (PA0), MUX bit 3
            (0 << MUX2)  |     
            (0 << MUX1)  |     
            (0 << MUX0);       

  ADCSRA = 
            (1 << ADEN)  |     // Enable ADC 
            (1 << ADPS2) |     // set prescaler to 64, bit 2 
            (1 << ADPS1) |     // set prescaler to 64, bit 1 
            (0 << ADPS0);      // set prescaler to 64, bit 0  
}
void initADCur()
{
  ADMUX =
            (0 << ADLAR) |     // left shift result
            (0 << REFS1) |     // Sets ref. voltage to VCC, bit 1
            (0 << REFS0) |     // Sets ref. voltage to VCC, bit 0
            (0 << MUX3)  |     // use ADC1 for input (PA1), MUX bit 3
            (0 << MUX2)  |     
            (0 << MUX1)  |     
            (1 << MUX0);       

  ADCSRA = 
            (1 << ADEN)  |     // Enable ADC 
            (1 << ADPS2) |     // set prescaler to 64, bit 2 
            (1 << ADPS1) |     // set prescaler to 64, bit 1 
            (0 << ADPS0);      // set prescaler to 64, bit 0  
}
void initADCdl()
{
  ADMUX =
            (0 << ADLAR) |     // left shift result
            (0 << REFS1) |     // Sets ref. voltage to VCC, bit 1
            (0 << REFS0) |     // Sets ref. voltage to VCC, bit 0
            (0 << MUX3)  |     // use ADC3 for input (PA3), MUX bit 3
            (0 << MUX2)  |     
            (1 << MUX1)  |     
            (1 << MUX0);       

  ADCSRA = 
            (1 << ADEN)  |     // Enable ADC 
            (1 << ADPS2) |     // set prescaler to 64, bit 2 
            (1 << ADPS1) |     // set prescaler to 64, bit 1 
            (0 << ADPS0);      // set prescaler to 64, bit 0  
}
void initADCdr()
{
  ADMUX =
            (0 << ADLAR) |     // left shift result
            (0 << REFS1) |     // Sets ref. voltage to VCC, bit 1
            (0 << REFS0) |     // Sets ref. voltage to VCC, bit 0
            (0 << MUX3)  |     // use ADC4 for input (PA4), MUX bit 3
            (1 << MUX2)  |     
            (0 << MUX1)  |     
            (0 << MUX0);      

  ADCSRA = 
            (1 << ADEN)  |     // Enable ADC 
            (1 << ADPS2) |     // set prescaler to 64, bit 2 
            (1 << ADPS1) |     // set prescaler to 64, bit 1 
            (0 << ADPS0);      // set prescaler to 64, bit 0  
}

int main(void) 
{
   int ul = 0;//up left
   int ur = 0;//up right
   int dl = 0;//down left
   int dr = 0;//down right

   int au = 0;//average up
   int ad = 0;//average down
   int al = 0;//average left
   int ar = 0;//average right
   //
   // initialize output pins
   //
   output(led_direction, red);
     
   output(led_direction, blue);

  while(1)
  { 
    initADCur();
    ADCSRA |= (1 << ADSC);         // start ADC measurement
    while (ADCSRA & (1 << ADSC) ); // wait till conversion complete 
    ur = ADCW;
    
    initADCul();
    ADCSRA |= (1 << ADSC);         // start ADC measurement
    while (ADCSRA & (1 << ADSC) ); // wait till conversion complete 
    ul = ADCW;
    
    initADCdl();
    ADCSRA |= (1 << ADSC);         // start ADC measurement
    while (ADCSRA & (1 << ADSC) ); // wait till conversion complete 
    dl = ADCW;
    
    initADCdr();
    ADCSRA |= (1 << ADSC);         // start ADC measurement
    while (ADCSRA & (1 << ADSC) ); // wait till conversion complete 
    dr = ADCW;

    au = (ul + ur)/2;
    ad = (dl + dr)/2;
    al = (ul + dl)/2;
    ar = (ur + dr)/2;

if (au > ad) {
set(led_port,red);
}
else if (au < ad) {
clear(led_port,red);
}
if (al > ar) {
set(led_port,blue);
}
else if (al < ar) {
clear(led_port,blue);
}
}
  return 0;
}
   


